var page = require('webpage').create();

page.onConsoleMessage = function (msg) {
    console.log(msg);
};

page.onCallback = function () {
    var output_path = '$PAGE_OUTPUT_PATH';
    var output_ext = output_path.split('.').pop();
    var dpi_zoom_adj = 1.0;
    var pdf_zoom_adj = 1.0;

    var chart = page.evaluate(function () {
        return eval("chart");
    });
    var render_params = page.evaluate(function () {
        return window["chart_render_params"];
    });

    if (render_params != null && render_params.zoom != null) {
        pdf_zoom_adj = render_params.zoom;
        dpi_zoom_adj = render_params.zoom;
    }

    if (navigator.platform == "MacIntel") {
        dpi_zoom_adj *= (96.0 / 72.0);
    }
    else if (output_ext == "pdf") {
        dpi_zoom_adj *= (96.0 / 72.0);
    }
    if (output_ext == "pdf") {
        pdf_zoom_adj *= 1.904;
        dpi_zoom_adj *= 1.904;
    }

    if (chart != null) {
        page.zoomFactor = pdf_zoom_adj;
        page.paperSize = { width: chart.width * dpi_zoom_adj, height: chart.height * dpi_zoom_adj };
    }

    page.render(output_path);
    phantom.exit();
};

page.open('$PAGE_HTML_PATH', function () {
    setTimeout(function () {
        console.log("render chart timeout!");
        phantom.exit();
    }, 10000);
});